@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid ">
			<div class="card border-0 shadow-custom">
				<div class="card-header border-grey">
					<h3 class="card-title">
						{{ __('membership.add_payment') }}
					</h3>
				</div>
				<form method="post" action="{{ route('transaction.store') }}">
					{{ csrf_field() }}
					<div class="card-body">
						<div class="row">
							<div class="col-lg-12">
								<div class="form-group">
									<label for="type">{{ __('membership.membership_type') }}</label>
									<select class="form-control @error('type') is-invalid @enderror" name="type"
										id="type" readonly>
										<option value="{{ $membership->id }}" selected>
											{{ $membership->membership_type->name }}
										</option>
									</select>
									@error('type')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="amount" class="required">{{ __('membership.amount') }}</label>
									<input value="{{ $due }}" max="{{ $due }}" type="number"
										class="form-control @error('amount') is-invalid @enderror" name="amount"
										id="amount" placeholder="0">
									@error('amount')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>

							<div class="col-lg-6">
								<div class="form-group">
									<label for="transaction_method">{{ __('membership.payment_method') }}</label>
									<select class="form-control" name="method" id="method">
										<option value="cash" {{ old('method')=='cash' ? 'selected' : '' }}>Cash</option>
										<option value="online" {{ old('method')=='online' ? 'selected' : '' }}>Online
										</option>
									</select>
								</div>
							</div>
							<div class="col-lg-12">
								<div class="form-group">
									<label for="payment-date" class="required">{{ __('membership.payment_date')
										}}</label>
									<div class="input-group date" id="payment-date" data-target-input="nearest">
										<input type="text" class="form-control @error('date') is-invalid @enderror"
											value="{{ old('date') }}" name="date" data-target="#payment-date" />
										<div class="input-group-append" data-target="#payment-date"
											data-toggle="datetimepicker">
											<div class="input-group-text"><i class="fa fa-calendar"></i></div>
										</div>
									</div>
									@error('date')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-12">
								<div class="form-group">
									<label for="note">{{ __('membership.note') }}</label>
									<textarea rows="4" class="form-control" name="note"
										id="note">{{ old('note') }}</textarea>
								</div>
							</div>
							<div class="col-lg-12">
								<button type="submit" class="btn btn-primary mt-1">{{ __('membership.save_payment')
									}}</button>
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
@endsection
@section('js-script')
<!-- PAGE SPECIFIC CUSTOM SCRIPT -->
<script>
	$(function () {
		"use strict";

		// INITIALIZE THE DATE PICKER
		$('#payment-date').datetimepicker({
			format: 'YYYY-MM-DD'
		});
	});
</script>
@endsection